﻿namespace Code6587EN.Ch02.ImportDesignAllSites
{
    using Microsoft.SharePoint;
    using Microsoft.SharePoint.Administration;
    using Microsoft.SharePoint.Publishing;
    using System;
    using System.IO;

    /// <summary>
    /// Console Application to import and apply a Design Package to all Site Collections
    /// in all content Web Applications.
    /// </summary>
    class Program
    {
        static void Main(string[] args)
        {
            // Set File Path
            var filePath = "C:\\My Code Design-1.0.wsp";
            
            // Get File Name from the File Path
            var fileName = Path.GetFileName(filePath);

            // Create a new Design Package Info object using the file name, an empty guid, the major version, and the minor version
            // We could parse the major and minor versions from the file name, however since that is being staticly provided, we 
            // will just do the same with the version.
            var package = new DesignPackageInfo(fileName, Guid.Empty, 1, 0);

            // Create a name for the temporary upload folder
            var tempFolderName = "temp_designupload" + Guid.NewGuid().ToString();

            // Open the file contents
            var fileBinary = File.OpenRead(filePath);

            // Iterate through each Web Application
            foreach (var webApp in SPWebService.ContentService.WebApplications)
            {
                // Iterate through each Site Collection in the Web Application
                foreach (SPSite site in webApp.Sites)
                {
                    // Ensure the Site Collection is in 2013 mode
                    if (site.CompatibilityLevel == 15)
                    {
                        // Get the Root Site of the Site Collection
                        using (var web = site.RootWeb)
                        {
                            // Create the temporary folder and upload the file
                            var tempFolder = web.RootFolder.SubFolders.Add(tempFolderName);
                            var file = tempFolder.Files.Add(fileName, fileBinary, true);

                            // Install the Design Package
                            DesignPackage.Install(site, package, file.Url);

                            // Delete the temporary folder
                            tempFolder.Delete();
                        }
                    }

                    // Dispose the Site Collection
                    site.Dispose();
                }
            }

            // Close the file
            fileBinary.Close();

            // Wait for a key to be pressed before closing the application
            Console.WriteLine("Press Any Key to Continue...");
            Console.Read();
        }
    }
}
